-- Insertar productos ADT (ejemplo con paquetes típicos de alarmas)
INSERT INTO products (name, description, price, installation_fee, monthly_fee, features, is_active) VALUES
  (
    'ADT Basic',
    'Paquete básico de seguridad para el hogar',
    45000,
    15000,
    5500,
    ARRAY['Panel de control táctil', '2 sensores de puertas/ventanas', '1 sensor de movimiento', 'Sirena interior', 'App móvil', 'Monitoreo 24/7'],
    true
  ),
  (
    'ADT Plus',
    'Protección completa con cámaras',
    75000,
    20000,
    7500,
    ARRAY['Panel de control táctil', '4 sensores de puertas/ventanas', '2 sensores de movimiento', '2 cámaras HD', 'Sirena interior/exterior', 'App móvil', 'Monitoreo 24/7', 'Grabación en nube 7 días'],
    true
  ),
  (
    'ADT Premium',
    'Máxima seguridad con automatización',
    120000,
    25000,
    9500,
    ARRAY['Panel de control táctil', '6 sensores de puertas/ventanas', '3 sensores de movimiento', '4 cámaras HD', 'Sirena interior/exterior', 'App móvil', 'Monitoreo 24/7', 'Grabación en nube 30 días', 'Control de accesos', 'Automatización del hogar', 'Botón de pánico'],
    true
  ),
  (
    'ADT Business',
    'Solución integral para negocios',
    180000,
    35000,
    12500,
    ARRAY['Panel de control profesional', '10 sensores de puertas/ventanas', '5 sensores de movimiento', '8 cámaras HD', 'Sirenas múltiples', 'App móvil', 'Monitoreo 24/7', 'Grabación en nube 60 días', 'Control de accesos', 'Detector de humo', 'Sensor de inundación', 'Soporte prioritario'],
    true
  );

-- Insertar usuario admin de ejemplo (password: admin123 - en producción usar bcrypt)
-- Este es solo para desarrollo, en producción se debe registrar con password hasheado
INSERT INTO users (email, password_hash, full_name, role, phone, status) VALUES
  ('admin@adtcrm.com', '$2b$10$YourHashedPasswordHere', 'Administrador CRM', 'admin', '+54 11 4444-5555', 'active');

-- Insertar algunos leads de ejemplo
INSERT INTO leads (first_name, last_name, email, phone, address, city, province, source, status, priority, notes) VALUES
  ('Juan', 'Pérez', 'juan.perez@email.com', '+54 11 5555-1234', 'Av. Corrientes 1234', 'Buenos Aires', 'CABA', 'web', 'new', 'high', 'Interesado en paquete Premium'),
  ('María', 'González', 'maria.gonzalez@email.com', '+54 11 5555-5678', 'Calle Falsa 567', 'La Plata', 'Buenos Aires', 'facebook', 'contacted', 'medium', 'Quiere cotización para casa de 3 ambientes'),
  ('Carlos', 'Rodríguez', 'carlos.r@email.com', '+54 351 444-9876', 'San Martín 890', 'Córdoba', 'Córdoba', 'google', 'qualified', 'high', 'Negocio familiar, necesita seguridad urgente'),
  ('Laura', 'Martínez', 'laura.m@email.com', '+54 261 333-4567', 'Mitre 234', 'Mendoza', 'Mendoza', 'referral', 'proposal', 'medium', 'Referido por cliente existente'),
  ('Roberto', 'Fernández', 'roberto.f@email.com', '+54 223 555-7890', 'Constitución 456', 'Mar del Plata', 'Buenos Aires', 'phone', 'new', 'low', 'Llamada entrante, pedir más información');
