"use client"

import { Button } from "@/components/ui/button"
import { Plus } from "lucide-react"
import { useState } from "react"
import { CreateDealDialog } from "./create-deal-dialog"

export function PipelineHeader() {
  const [open, setOpen] = useState(false)

  return (
    <>
      <div className="flex items-center justify-between">
        <div>
          <h2 className="text-3xl font-bold text-slate-900">Pipeline de Ventas</h2>
          <p className="text-slate-600 mt-1">Visualiza y gestiona tus oportunidades de venta</p>
        </div>
        <Button onClick={() => setOpen(true)} className="gap-2">
          <Plus className="h-4 w-4" />
          Nueva Oportunidad
        </Button>
      </div>
      <CreateDealDialog open={open} onOpenChange={setOpen} />
    </>
  )
}
