"use client"
import { Card } from "@/components/ui/card"
import { Badge } from "@/components/ui/badge"
import { DealCard } from "./deal-card"

interface PipelineBoardProps {
  deals: any[]
}

const stages = [
  { id: "prospecting", label: "Prospección", color: "bg-slate-100" },
  { id: "qualification", label: "Calificación", color: "bg-blue-100" },
  { id: "proposal", label: "Propuesta", color: "bg-purple-100" },
  { id: "negotiation", label: "Negociación", color: "bg-amber-100" },
  { id: "closed-won", label: "Ganado", color: "bg-green-100" },
  { id: "closed-lost", label: "Perdido", color: "bg-red-100" },
]

export function PipelineBoard({ deals }: PipelineBoardProps) {
  const getDealsByStage = (stageId: string) => {
    return deals.filter((deal) => deal.stage === stageId)
  }

  const getStageValue = (stageId: string) => {
    const stageDeals = getDealsByStage(stageId)
    return stageDeals.reduce((sum, deal) => sum + Number(deal.amount), 0)
  }

  const formatCurrency = (amount: number) => {
    return new Intl.NumberFormat("es-AR", {
      style: "currency",
      currency: "ARS",
      minimumFractionDigits: 0,
    }).format(amount)
  }

  return (
    <div className="overflow-x-auto pb-4">
      <div className="flex gap-4 min-w-max">
        {stages.map((stage) => {
          const stageDeals = getDealsByStage(stage.id)
          const stageValue = getStageValue(stage.id)

          return (
            <div key={stage.id} className="w-80 flex-shrink-0">
              <Card className={`${stage.color} border-2 mb-4`}>
                <div className="p-4">
                  <div className="flex items-center justify-between mb-2">
                    <h3 className="font-semibold text-slate-900">{stage.label}</h3>
                    <Badge variant="secondary" className="bg-white">
                      {stageDeals.length}
                    </Badge>
                  </div>
                  <p className="text-sm font-medium text-slate-700">{formatCurrency(stageValue)}</p>
                </div>
              </Card>

              <div className="space-y-3">
                {stageDeals.length === 0 ? (
                  <Card className="p-6 text-center border-dashed">
                    <p className="text-sm text-slate-500">No hay oportunidades</p>
                  </Card>
                ) : (
                  stageDeals.map((deal) => <DealCard key={deal.id} deal={deal} />)
                )}
              </div>
            </div>
          )
        })}
      </div>
    </div>
  )
}
