import { Card } from "@/components/ui/card"
import { Phone, PhoneCall, Clock, ThumbsUp, Calendar, CheckCircle2 } from "lucide-react"

interface CallsStatsProps {
  totalCalls: number
  todayCalls: number
  completedCalls: number
  avgDuration: number
  interestedCalls: number
  callbackScheduled: number
}

export function CallsStats({
  totalCalls,
  todayCalls,
  completedCalls,
  avgDuration,
  interestedCalls,
  callbackScheduled,
}: CallsStatsProps) {
  const formatDuration = (seconds: number) => {
    const minutes = Math.floor(seconds / 60)
    const secs = seconds % 60
    return `${minutes}:${secs.toString().padStart(2, "0")}`
  }

  const stats = [
    {
      label: "Total Llamadas",
      value: totalCalls,
      icon: Phone,
      color: "text-blue-600",
      bg: "bg-blue-50",
      subtitle: "Todas las llamadas",
    },
    {
      label: "Hoy",
      value: todayCalls,
      icon: PhoneCall,
      color: "text-green-600",
      bg: "bg-green-50",
      subtitle: "Llamadas de hoy",
    },
    {
      label: "Completadas",
      value: completedCalls,
      icon: CheckCircle2,
      color: "text-purple-600",
      bg: "bg-purple-50",
      subtitle: "Conexiones exitosas",
    },
    {
      label: "Duración Promedio",
      value: formatDuration(avgDuration),
      icon: Clock,
      color: "text-amber-600",
      bg: "bg-amber-50",
      subtitle: "Tiempo por llamada",
    },
    {
      label: "Interesados",
      value: interestedCalls,
      icon: ThumbsUp,
      color: "text-emerald-600",
      bg: "bg-emerald-50",
      subtitle: "Clientes potenciales",
    },
    {
      label: "Callbacks Agendados",
      value: callbackScheduled,
      icon: Calendar,
      color: "text-rose-600",
      bg: "bg-rose-50",
      subtitle: "Pendientes de llamar",
    },
  ]

  return (
    <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 xl:grid-cols-6 gap-4">
      {stats.map((stat) => {
        const Icon = stat.icon
        return (
          <Card key={stat.label} className="p-4">
            <div className="flex items-start justify-between">
              <div>
                <p className="text-xs font-medium text-slate-600">{stat.label}</p>
                <p className="text-2xl font-bold text-slate-900 mt-2">{stat.value}</p>
                <p className="text-xs text-slate-500 mt-1">{stat.subtitle}</p>
              </div>
              <div className={`${stat.bg} p-2 rounded-lg`}>
                <Icon className={`h-4 w-4 ${stat.color}`} />
              </div>
            </div>
          </Card>
        )
      })}
    </div>
  )
}
