import { RegisterForm } from "@/components/auth/register-form"
import type { Metadata } from "next"

export const metadata: Metadata = {
  title: "Registro - CRM ADT",
  description: "Crea tu cuenta en el CRM de ADT Alarmas",
}

export default function RegisterPage() {
  return (
    <div className="min-h-screen flex items-center justify-center bg-gradient-to-br from-blue-50 to-slate-100 px-4 py-12">
      <div className="w-full max-w-md">
        <div className="text-center mb-8">
          <h1 className="text-4xl font-bold text-slate-900 mb-2">ADT CRM</h1>
          <p className="text-slate-600">Crea tu cuenta</p>
        </div>
        <RegisterForm />
      </div>
    </div>
  )
}
