import { LoginForm } from "@/components/auth/login-form"
import type { Metadata } from "next"

export const metadata: Metadata = {
  title: "Iniciar Sesión - CRM ADT",
  description: "Accede a tu cuenta del CRM de ADT Alarmas",
}

export default function LoginPage() {
  return (
    <div className="min-h-screen flex items-center justify-center bg-gradient-to-br from-blue-50 to-slate-100 px-4">
      <div className="w-full max-w-md">
        <div className="text-center mb-8">
          <h1 className="text-4xl font-bold text-slate-900 mb-2">ADT CRM</h1>
          <p className="text-slate-600">Sistema de Gestión de Ventas</p>
        </div>
        <LoginForm />
      </div>
    </div>
  )
}
