import { requireAuth } from "@/lib/auth/get-user"
import { getSupabaseServerClient } from "@/lib/supabase/server"
import { LeadsTable } from "@/components/leads/leads-table"
import { LeadsHeader } from "@/components/leads/leads-header"
import { LeadsStats } from "@/components/leads/leads-stats"

export default async function LeadsPage() {
  const user = await requireAuth()
  const supabase = await getSupabaseServerClient()

  // Get leads based on user role
  let leadsQuery = supabase
    .from("leads")
    .select("*, assigned_to_user:users!leads_assigned_to_fkey(full_name)")
    .order("created_at", { ascending: false })

  // Agents only see their assigned leads
  if (user.role === "agent") {
    leadsQuery = leadsQuery.eq("assigned_to", user.id)
  }

  const { data: leads, error } = await leadsQuery

  // Get stats
  const { count: totalLeads } = await supabase.from("leads").select("*", { count: "exact", head: true })

  const { count: newLeads } = await supabase
    .from("leads")
    .select("*", { count: "exact", head: true })
    .eq("status", "new")

  const { count: qualifiedLeads } = await supabase
    .from("leads")
    .select("*", { count: "exact", head: true })
    .eq("status", "qualified")

  const { count: wonLeads } = await supabase
    .from("leads")
    .select("*", { count: "exact", head: true })
    .eq("status", "won")

  return (
    <div className="space-y-6">
      <LeadsHeader />
      <LeadsStats
        total={totalLeads || 0}
        newLeads={newLeads || 0}
        qualified={qualifiedLeads || 0}
        won={wonLeads || 0}
      />
      <LeadsTable leads={leads || []} />
    </div>
  )
}
