import type React from "react"
import { requireAuth } from "@/lib/auth/get-user"
import { DashboardNav } from "@/components/dashboard/dashboard-nav"
import { UserMenu } from "@/components/dashboard/user-menu"

export default async function DashboardLayout({ children }: { children: React.ReactNode }) {
  const user = await requireAuth()

  return (
    <div className="min-h-screen bg-slate-50">
      <header className="bg-white border-b border-slate-200 sticky top-0 z-40">
        <div className="flex items-center justify-between px-6 py-4">
          <div className="flex items-center gap-8">
            <h1 className="text-2xl font-bold text-slate-900">ADT CRM</h1>
            <DashboardNav />
          </div>
          <UserMenu user={user} />
        </div>
      </header>
      <main className="p-6">{children}</main>
    </div>
  )
}
